import React, {Component} from 'react';
import PropTypes from 'prop-types';
import gql from 'graphql-tag';
import {graphql, compose} from "react-apollo";
import BlinkDot from "../Loading/BlinkDot";

class UsersBreadcrumb extends Component {

    render() {
        const {data} = this.props;
        const {loading, utente} = data;

        if(loading) {
            return (<span className="text-info" style={{fontWeight: "normal", fontSize: "1.3rem"}}>
                <BlinkDot/>
                <BlinkDot/>
                <BlinkDot/>
            </span>)
        }

        return (<span>
            {utente.id}
        </span>);
    }
}

export default compose(
    graphql(gql`
        query($id: String) {
            utente(id: $id) {
                id
            }
        }
    `, {
        options:({id}) => {return{variables: {id: id}}},
    }),
)(UsersBreadcrumb);

UsersBreadcrumb.defaultProps = {};

UsersBreadcrumb.propTypes = {};